/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission;

import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.dto.PaymentDetailDto;
import com.google.common.util.concurrent.AtomicDouble;
import com.service.invoice.commission.BaseMidMenCommission;
import com.service.invoice.commission.util.CodeFinder;
import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;

class ProductMidMenCommission
extends BaseMidMenCommission {
    private boolean commDiffersBetweenEachProductAndMidMan;
    private boolean chooseMidManPerDtl;
    private boolean calcCommissionByBothMidManAndProduct;

    public ProductMidMenCommission(DbLogin dbLogin, InvoiceDto.InvoiceInfo invoice) {
        super(dbLogin, invoice);
        this.fetchSettings();
    }

    private void fetchSettings() {
        Map result = this.settingsDao.getMapMultiple(rowSet -> rowSet.getBoolean("Boolean"), "[Boolean]", "0", this.login, new String[]{"ArtForVaseteh", "ChBoxVasetehSatri", "Porsant_vaset"});
        this.commDiffersBetweenEachProductAndMidMan = result.getOrDefault("ArtForVaseteh", false);
        this.chooseMidManPerDtl = result.getOrDefault("ChBoxVasetehSatri", false);
        this.calcCommissionByBothMidManAndProduct = result.getOrDefault("Porsant_vaset", false);
    }

    protected String generateInsertFConnectValues() {
        if (this.chooseMidManPerDtl) {
            return this.perDtlInsertFConnectValues();
        }
        return super.generateInsertFConnectValues();
    }

    private String perDtlInsertFConnectValues() {
        StringBuilder sb = new StringBuilder();
        this.setMidManPercentToDtl(this.invoice.getDetailinfo());
        for (int i = 0; i < this.invoice.getDetailinfo().size(); ++i) {
            InvoiceDetailDto dtl = (InvoiceDetailDto)this.invoice.getDetailinfo().get(i);
            double midManComm = ConvertStr.nullSafeDouble((Double)dtl.getMidmancommissionpercent());
            dtl.setMidManTotalCommission(midManComm * this.getFinalSumPrice(dtl) / 100.0);
            sb.append("(").append(this.getFConnectCommonValues()).append("'").append(dtl.getMidManCode()).append("', ").append(midManComm).append(", ").append(dtl.getMidManTotalCommission()).append(", '").append(dtl.getProductid()).append("', ").append(i + 1).append(", 0),");
        }
        return ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",").toString();
    }

    private void setMidManPercentToDtl(List<InvoiceDetailDto> dtlList) {
        CodeFinder codeFinder = new CodeFinder(new CodeFinder.CodeFinderArgs(dtl -> this.getId(dtl) + "-" + dtl.getMidManCode(), arg_0 -> this.calculateMidManDefaultComm(arg_0), arg_0 -> this.getFinalSumPrice(arg_0), dtlList));
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT A_CODE + '-' + C_CODE ACCode, IsNull(DarsadPorsantV, 0) comm \n FROM PorsantVaseteh WHERE A_CODE + '-' + C_CODE IN (" + ConvertStr.commaBindStringsWithQuotes(codeFinder.getNoCommProvidedCodes().keySet()) + ")");
        while (rs.next()) {
            List dataList = (List)codeFinder.getNoCommProvidedCodes().get(rs.getString("ACCode"));
            for (InvoiceDetailDto data : dataList) {
                data.setMidmancommissionpercent(Double.valueOf(rs.getDouble("comm")));
            }
        }
    }

    protected double innerCalculateCommission() {
        if (!this.chooseMidManPerDtl) {
            this.emptyUserGivenDtlMidManCodes();
        }
        if (!this.commDiffersBetweenEachProductAndMidMan && !this.chooseMidManPerDtl) {
            return this.calcNormal();
        }
        if (this.chooseMidManPerDtl) {
            this.invoice.setMidmanerpcode("");
            this.invoice.setCommission(Double.valueOf(0.0));
            this.checkErrorPerDtl();
        }
        if (this.chooseMidManPerDtl && this.commDiffersBetweenEachProductAndMidMan) {
            this.checkErrorsForMidManPerDtlOption(dtl -> this.getId(dtl) + "-" + dtl.getMidManCode());
        }
        this.checkDtlCommissionsArePercent();
        return this.calcPerMidMan(dtl -> this.getId(dtl) + "-" + dtl.getMidManCode());
    }

    protected final void checkDtlCommissionsArePercent() {
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            if (dtl.getMidmancommissionpercent() == null || !(dtl.getMidmancommissionpercent() < 0.0) && !(dtl.getMidmancommissionpercent() > 100.0)) continue;
            throw new TncException(TncExceptionMessages.INVALID_GIVEN_MID_MAN_PERCENT);
        }
    }

    private double calcNormal() {
        CodeFinder codeFinder = new CodeFinder(new CodeFinder.CodeFinderArgs(InvoiceDetailDto::getProductid, arg_0 -> this.calculateMidManDefaultComm(arg_0), arg_0 -> this.getFinalSumPrice(arg_0), this.invoice.getDetailinfo()));
        AtomicDouble sumOfCommissionPrices = codeFinder.getProvidedCommSum();
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT IsNull(DarsadPorsant, 0) comm, A_CODE \n FROM ARTICLE WHERE A_CODE IN \n(" + ConvertStr.commaBindStringsWithQuotes(codeFinder.getNoCommProvidedCodes().keySet()) + ")");
        return sumOfCommissionPrices.addAndGet(this.readCommissionFromRowSet(rs, codeFinder, "A_CODE"));
    }

    private void checkErrorPerDtl() throws TncException {
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            if (!ConvertStr.isNullOrEmpty((String)dtl.getMidmanerpcode())) continue;
            throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
        }
        this.checkGivenCodesAreMidMen();
    }

    private void checkGivenCodesAreMidMen() {
        List midManCodes = this.invoice.getDetailinfo().stream().map(dtl -> dtl.getMidManCode() + "1").collect(Collectors.toList());
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT Vaseteh FROM CUSTOMER \n WHERE C_CODE + CAST(Vaseteh AS NVARCHAR(1)) IN (" + ConvertStr.commaBindStringsWithQuotes(midManCodes) + ")");
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
        }
    }

    protected final void checkErrorsForMidManPerDtlOption(Function<InvoiceDetailDto, String> dtlCodeGeneration) {
        this.checkDtlCommissionsArePercent();
        List aCCodes = this.invoice.getDetailinfo().stream().filter(dtl -> {
            if (!ConvertStr.isNullOrEmpty((String)dtl.getMidmanerpcode()) && ConvertStr.nullSafeDouble((Double)dtl.getMidmancommissionpercent()) == 0.0) {
                return true;
            }
            if (!this.chooseMidManPerDtl) {
                dtl.setMidManCode(this.invoice.getMidmanerpcode());
            }
            return false;
        }).map(dtlCodeGeneration).collect(Collectors.toList());
        ArrayList tmpACCodes = new ArrayList(aCCodes);
        for (String aCCode : tmpACCodes) {
            String aCode = aCCode.split("-")[0];
            SqlRowSet rs = this.jdbc.queryForRowSet("SELECT count(A_CODE) cnt \n FROM PorsantVaseteh WHERE A_CODE = ?", new Object[]{aCode});
            rs.next();
            if (rs.getInt("cnt") != 0) continue;
            aCCodes.remove(aCCode);
        }
        if (aCCodes.isEmpty()) {
            return;
        }
        List listOfAvailableCommissions = this.jdbc.queryForList("SELECT A_CODE + '-' + C_CODE ACCode, IsNull(DarsadPorsantV, 0) comm \n FROM PorsantVaseteh \n WHERE A_CODE + '-' + C_CODE IN (" + ConvertStr.commaBindStringsWithQuotes(aCCodes) + ")");
        if (listOfAvailableCommissions.isEmpty() || listOfAvailableCommissions.size() != aCCodes.size()) {
            throw new TncException(TncExceptionMessages.GIVEN_MID_MAN_NOT_DEFINED_FOR_PRODUCT);
        }
    }

    protected final double calcPerMidMan(Function<InvoiceDetailDto, String> generateDtlIdFunction) {
        CodeFinder codeFinder = new CodeFinder(new CodeFinder.CodeFinderArgs(generateDtlIdFunction, arg_0 -> this.calculateMidManDefaultComm(arg_0), arg_0 -> this.getFinalSumPrice(arg_0), this.invoice.getDetailinfo()));
        AtomicDouble sumOfCommissionPrices = codeFinder.getProvidedCommSum();
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT A_CODE + '-' + C_CODE ACCode, IsNull(DarsadPorsantV, 0) comm \n FROM PorsantVaseteh \n WHERE A_CODE + '-' + C_CODE IN (" + ConvertStr.commaBindStringsWithQuotes(codeFinder.getNoCommProvidedCodes().keySet()) + ")");
        sumOfCommissionPrices.addAndGet(this.readCommissionFromRowSet(rs, codeFinder, "ACCode"));
        if (!codeFinder.getNoCommProvidedCodes().isEmpty()) {
            for (List dtlList : codeFinder.getNoCommProvidedCodes().values()) {
                for (InvoiceDetailDto dtl : dtlList) {
                    sumOfCommissionPrices.addAndGet(this.calculateFinalSum(0.0, dtl));
                }
            }
        }
        return sumOfCommissionPrices.get();
    }

    protected final double calculateMidManDefaultComm(InvoiceDetailDto dtl) {
        if (this.chooseMidManPerDtl && dtl.getMidmancommissionpercent() != null) {
            return 0.0;
        }
        return this.calculateFinalSum(0.0, dtl);
    }

    protected final double calculateFinalSum(double commission, InvoiceDetailDto noCommissionProvidedDtl) {
        double finalPrice = this.getFinalSumPrice(noCommissionProvidedDtl);
        String midManCode = ConvertStr.isNullOrEmpty((String)noCommissionProvidedDtl.getMidManCode()) ? this.invoice.getMidmanerpcode() : noCommissionProvidedDtl.getMidManCode();
        double midManCommission = this.calcCommissionByBothMidManAndProduct ? this.getMidManCommissionPercent(midManCode) : 0.0;
        return finalPrice * commission / 100.0 + finalPrice * midManCommission / 100.0;
    }

    protected final double getFinalSumPrice(InvoiceDetailDto dtl) {
        return this.isCalcCommissionAfterDiscount() ? dtl.sumPriceNoTaxMinusDiscount() : dtl.calcSumPriceNoTax();
    }

    protected final double readCommissionFromRowSet(SqlRowSet rs, CodeFinder codeFinder, String codeAlias) {
        AtomicDouble sumOfCommissionPrices = new AtomicDouble(0.0);
        while (rs.next()) {
            List noCommProvidedDtlList = (List)codeFinder.getNoCommProvidedCodes().remove(rs.getString(codeAlias));
            for (InvoiceDetailDto data : noCommProvidedDtlList) {
                double commission = rs.getDouble("comm");
                sumOfCommissionPrices.addAndGet(this.calculateFinalSum(commission, data));
                data.setMidmancommissionpercent(Double.valueOf(commission));
            }
        }
        return sumOfCommissionPrices.get();
    }

    protected String getCostHeadingForFConnect() {
        if (this.chooseMidManPerDtl) {
            return "";
        }
        return super.getCostHeadingForFConnect();
    }

    @NotNull
    protected List<PaymentDetailDto> internalCommissionSndListData() {
        if (!this.chooseMidManPerDtl) {
            return super.internalCommissionSndListData();
        }
        ArrayList<PaymentDetailDto> result = new ArrayList<PaymentDetailDto>();
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            if (dtl.getMidManTotalCommission() == 0.0) continue;
            result.add(this.getCommRow(this.getMidManHeading(dtl.getMidManCode()), dtl.getMidManTotalCommission()));
        }
        if (result.isEmpty()) {
            return result;
        }
        this.invoice.setMidmanerpcode(((InvoiceDetailDto)ConvertStr.getLast((List)this.invoice.getDetailinfo())).getMidManCode());
        result.add(this.getCommCostSndListRow());
        return result;
    }

    protected boolean isTotalCommissionAvailable() {
        return !this.chooseMidManPerDtl;
    }

    protected double getMidManCommissionPercent(String midManCode) {
        if (this.chooseMidManPerDtl) {
            return this.getMidManCommissionFromCustomerTable(midManCode);
        }
        return super.getMidManCommissionPercent(midManCode);
    }

    private String getId(InvoiceDetailDto dtl) {
        return dtl.getProductid();
    }
}

